/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntitySummonArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class SummonCommand {
    private static final SimpleCommandExceptionType f_138810_ = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.summon.failed"));
    private static final SimpleCommandExceptionType f_138811_ = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.summon.failed.uuid"));
    private static final SimpleCommandExceptionType f_138812_ = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.summon.invalidPosition"));

    public static void m_138814_(CommandDispatcher<CommandSourceStack> p_138815_) {
        p_138815_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_("summon").requires(p_138819_ -> p_138819_.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_("entity", EntitySummonArgument.m_93335_()).suggests(SuggestionProviders.f_121645_).executes(p_138832_ -> SummonCommand.m_138820_((CommandSourceStack)p_138832_.getSource(), EntitySummonArgument.m_93338_((CommandContext)p_138832_, (String)"entity"), ((CommandSourceStack)p_138832_.getSource()).m_81371_(), new CompoundTag(), true))).then(((RequiredArgumentBuilder)Commands.m_82129_("pos", Vec3Argument.m_120841_()).executes(p_138830_ -> SummonCommand.m_138820_((CommandSourceStack)p_138830_.getSource(), EntitySummonArgument.m_93338_((CommandContext)p_138830_, (String)"entity"), Vec3Argument.m_120844_((CommandContext)p_138830_, (String)"pos"), new CompoundTag(), true))).then(Commands.m_82129_("nbt", CompoundTagArgument.m_87657_()).executes(p_138817_ -> SummonCommand.m_138820_((CommandSourceStack)p_138817_.getSource(), EntitySummonArgument.m_93338_((CommandContext)p_138817_, (String)"entity"), Vec3Argument.m_120844_((CommandContext)p_138817_, (String)"pos"), CompoundTagArgument.m_87660_((CommandContext)p_138817_, (String)"nbt"), false))))));
    }

    private static int m_138820_(CommandSourceStack p_138821_, ResourceLocation p_138822_, Vec3 p_138823_, CompoundTag p_138824_, boolean p_138825_) throws CommandSyntaxException {
        BlockPos blockpos = new BlockPos(p_138823_);
        if (!Level.m_46741_(blockpos)) {
            throw f_138812_.create();
        }
        CompoundTag compoundtag = p_138824_.m_6426_();
        compoundtag.m_128359_("id", p_138822_.toString());
        ServerLevel serverlevel = p_138821_.m_81372_();
        Entity entity = EntityType.m_20645_(compoundtag, serverlevel, p_138828_ -> {
            p_138828_.m_7678_(p_138827_.f_82479_, p_138827_.f_82480_, p_138827_.f_82481_, p_138828_.m_146908_(), p_138828_.m_146909_());
            return p_138828_;
        });
        if (entity == null) {
            throw f_138810_.create();
        }
        if (p_138825_ && entity instanceof Mob && !ForgeEventFactory.doSpecialSpawn((Mob)((Mob)entity), (LevelAccessor)p_138821_.m_81372_(), (float)((float)entity.m_20185_()), (float)((float)entity.m_20186_()), (float)((float)entity.m_20189_()), null, (MobSpawnType)MobSpawnType.COMMAND)) {
            ((Mob)entity).m_6518_((ServerLevelAccessor)p_138821_.m_81372_(), p_138821_.m_81372_().m_6436_(entity.m_20183_()), MobSpawnType.COMMAND, null, null);
        }
        if (!serverlevel.m_8860_(entity)) {
            throw f_138811_.create();
        }
        p_138821_.m_81354_((Component)Component.m_237110_((String)"commands.summon.success", (Object[])new Object[]{entity.m_5446_()}), true);
        return 1;
    }
}

